if unsupported then return end

-- Load Textures
local TEX_EXCLAMATION_BLOCK = get_texture_info("exclamation_box_seg8_texture_08012E28")
local TEX_BREAK_BOX = get_texture_info("water_ring_seg6_texture_06012380")

--- @class Box
--- @field public x integer
--- @field public y integer
--- @field public w integer
--- @field public h integer
--- @field public cornerRadius integer

gGlobalSyncTable.newTimer = 0
gGlobalSyncTable.votingTimer = (16 * 30) + 40
gGlobalSyncTable.mapDeciding = false
gGlobalSyncTable.course1_v = 0
gGlobalSyncTable.course2_v = 0
gGlobalSyncTable.course3_v = 0

--- Locals

local pickedMap = false
local position = 1
local screenWidth = djui_hud_get_screen_width()
local theme = get_selected_theme()

if network_is_server() then
    gGlobalSyncTable.course1 = math.random(#gLevels)
    gGlobalSyncTable.course2 = math.random(#gLevels)
    gGlobalSyncTable.course3 = math.random(#gLevels)
end

gBoxTable = {}

local function truncateString(inputString, maxLength)
    if #inputString > maxLength then
        return string.sub(inputString, 1, maxLength - 3) .. "..."
    else
        return inputString
    end
end

local function add_new_box(x, y, w, h, cornerRadius)
    table.insert(gBoxTable, {x = x, y = y, w = w, h = h, cornerRadius = cornerRadius})
end

local function move_hud_box(boxnum, dist, angle)
    local angle_rad = math.rad(angle)
    local dx = dist * math.cos(angle_rad)
    local dy = dist * math.sin(angle_rad)

    for i, box in pairs(gBoxTable) do
        if i == boxnum then
            box.x = box.x + dx
            box.y = box.y + dy
        end
    end
end

function init_voting_menu()
    if network_is_server() then
        gGlobalSyncTable.votingTimer = (16 * 30) + 40
        gGlobalSyncTable.newTimer = 0
        gGlobalSyncTable.alpha = 0
    end

    if #gBoxTable == 0 then
        add_new_box((screenWidth / 2) - 512, 384, 256, 256, 16)
        add_new_box((screenWidth / 2) - 128, 384, 256, 256, 16)
        add_new_box((screenWidth / 2) + 256, 384, 256, 256, 16)

        -- Name Boxes
        add_new_box((screenWidth / 2) - (512 - 42), 670, 340, 70, 0)
        add_new_box((screenWidth / 2) - (128 - 42), 670, 340, 70, 0)
        add_new_box((screenWidth / 2) + (256 + 42), 670, 340, 70, 0)
    end
end

function host_init_voting_timer()
    if network_is_server() then
        gGlobalSyncTable.course1_v = 0
        gGlobalSyncTable.course2_v = 0
        gGlobalSyncTable.course3_v = 0
        gGlobalSyncTable.mapDeciding = true

        repeat
        gGlobalSyncTable.course1 = math.random(#gLevels)
        gGlobalSyncTable.course2 = math.random(#gLevels)
        gGlobalSyncTable.course3 = math.random(#gLevels)
        until gGlobalSyncTable.course1 ~= gGlobalSyncTable.course2 and
            gGlobalSyncTable.course1 ~= gGlobalSyncTable.course3 and
            gGlobalSyncTable.course2 ~= gGlobalSyncTable.course3
    end
    if network_is_server() then
        gGlobalSyncTable.votingTimer = (16 * 30) + 40
        gGlobalSyncTable.newTimer = 0
        gGlobalSyncTable.alpha = 0
    end

    gBoxTable = {}

    -- Name Boxes
    add_new_box((screenWidth / 2) - (512 - 42), 655, 170, 32, 16)
    add_new_box((screenWidth / 2) - (128 - 42), 655, 170, 32, 16)
    add_new_box((screenWidth / 2) + (256 + 42), 655, 170, 32, 16)
end

local function on_hud_render()
    if gGlobalSyncTable.mapDeciding then
        if gGlobalSyncTable.newTimer < 128 then
            if gGlobalSyncTable.newTimer < 45 then
                if network_is_server() then
                    gGlobalSyncTable.alpha = gGlobalSyncTable.alpha + 5.67
                end
            elseif gGlobalSyncTable.alpha ~= 0 then
                if network_is_server() then
                    gGlobalSyncTable.alpha = math.max(gGlobalSyncTable.alpha - 5.67, 0)
                end
            end
        elseif gGlobalSyncTable.newTimer > 480 then
            if network_is_server() then
                gGlobalSyncTable.alpha = gGlobalSyncTable.alpha + 5.67
            end
        end

        if network_is_server() then
            gGlobalSyncTable.votingTimer = gGlobalSyncTable.votingTimer - 1
        end

        if network_is_server() then
            gGlobalSyncTable.newTimer = gGlobalSyncTable.newTimer + 1
        end

        if gGlobalSyncTable.newTimer > 45 then
            set_background_music(0, 94, 60)
            gLakituState.mode = CAMERA_MODE_NONE

            if gGlobalSyncTable.newTimer == 480 then
                fade_volume_scale(0, 0, 45)
            end

            djui_hud_set_adjusted_color(theme.background.r, theme.background.g, theme.background.b, 255)
            djui_hud_render_rect(0, 0, 8192, 8192)

            djui_hud_set_adjusted_color(255, 255, 255, 25)

            for i = 0, math.ceil(screenWidth / 30) do
                for j = 0, 10 do
                    djui_hud_render_texture(TEX_EXCLAMATION_BLOCK, i * 128 + ((gGlobalSyncTable.newTimer % 64) * 8) - 512, j * 128 + (math.sin(gGlobalSyncTable.newTimer / 16) * 64) - 128, 4, 4)
                end
            end

            for i = 0, 32 do
                for j = 0, 2 do
                    djui_hud_render_texture(TEX_BREAK_BOX, i * 512 + ((gGlobalSyncTable.newTimer % 128) * 12) - 4096, j * 512, 16, 16)
                end
            end

            djui_hud_set_font(FONT_MENU)
            djui_hud_set_adjusted_color(255, 255, 255, 255)

            if gGlobalSyncTable.newTimer < 128 then
                djui_hud_print_text("Voting will begin in " .. math.floor(gGlobalSyncTable.votingTimer / 30) - 12, (screenWidth / 2) - djui_hud_measure_text("Voting will begin in ".. math.floor(gGlobalSyncTable.votingTimer / 30)), 75, 2)
            else
                djui_hud_print_text("You may now begin voting.", (screenWidth / 2) - djui_hud_measure_text("You may now begin voting."), 75, 2)
            end


            gBoxTable = {}

            -- Name Boxes
            add_new_box((screenWidth / 2) - (512 - 42), 655, 340, 70, 0)
            add_new_box((screenWidth / 2) - (128 - 42), 655, 340, 70, 0)
            add_new_box((screenWidth / 2) + (256 + 42), 655, 340, 70, 0)

            for i, box in ipairs(gBoxTable) do
                djui_hud_set_adjusted_color(theme.rect.r, theme.rect.g, theme.rect.b, 155)
                djui_hud_render_rect(box.x + box.cornerRadius, box.y, box.w - (box.cornerRadius * 2), box.h)
                djui_hud_render_rect(box.x, box.y + box.cornerRadius, box.cornerRadius, box.h - (box.cornerRadius * 2))
                djui_hud_render_rect(box.x + box.w - box.cornerRadius, box.y + box.cornerRadius, box.cornerRadius, box.h - (box.cornerRadius * 2))
            end

            -- Centered Text

            djui_hud_set_font(FONT_NORMAL)

            djui_hud_set_adjusted_color(255, 255, 255, 255)

            djui_hud_print_text(name_of_level(gLevels[gGlobalSyncTable.course1].level, gLevels[gGlobalSyncTable.course1].area, gLevels[gGlobalSyncTable.course1].name, gLevels[gGlobalSyncTable.course1]) .. ": " .. tostring(gGlobalSyncTable.course1_v), ((djui_hud_get_screen_width() / 2) - 284) - (djui_hud_measure_text(name_of_level(gLevels[gGlobalSyncTable.course1].level, gLevels[gGlobalSyncTable.course1].area, gLevels[gGlobalSyncTable.course1].name, gLevels[gGlobalSyncTable.course1]) .. ": " .. tostring(gGlobalSyncTable.course1_v) .. ": " .. tostring(gGlobalSyncTable.course1_v))) / 2, 670, 1)

            djui_hud_print_text(name_of_level(gLevels[gGlobalSyncTable.course2].level, gLevels[gGlobalSyncTable.course2].area, gLevels[gGlobalSyncTable.course2].name, gLevels[gGlobalSyncTable.course2]) .. ": " .. tostring(gGlobalSyncTable.course2_v), (djui_hud_get_screen_width() / 2 + 9) - (djui_hud_measure_text(truncateString(tostring(gLevels[gGlobalSyncTable.course2].name), 9) .. ": " .. tostring(gGlobalSyncTable.course2_v)) / 2), 670, 1)

            djui_hud_print_text(tostring(name_of_level(gLevels[gGlobalSyncTable.course3].level, gLevels[gGlobalSyncTable.course3].area, gLevels[gGlobalSyncTable.course3].name, gLevels[gGlobalSyncTable.course3])) .. ": " .. tostring(gGlobalSyncTable.course3_v), ((djui_hud_get_screen_width() / 2) + 373) - (djui_hud_measure_text(truncateString(tostring(gLevels[gGlobalSyncTable.course3].name), 9) .. ": " .. tostring(gGlobalSyncTable.course3_v)) / 3.5), 670, 1)
        end

        -- Black Fade

        djui_hud_set_adjusted_color(0, 0, 0, math.floor(gGlobalSyncTable.alpha))

        djui_hud_render_rect(0, 0, 8192, 8192)

        hud_hide()
    end

    if gGlobalSyncTable.votingTimer <= 0 then
        stop_background_music(94)

        local highest_v = math.max(gGlobalSyncTable.course1_v, gGlobalSyncTable.course2_v, gGlobalSyncTable.course3_v)

        local highest_courses = {}
        if highest_v == gGlobalSyncTable.course1_v then
            table.insert(highest_courses, gGlobalSyncTable.course1)
        end
        if highest_v == gGlobalSyncTable.course2_v then
            table.insert(highest_courses, gGlobalSyncTable.course2)
        end
        if highest_v == gGlobalSyncTable.course3_v then
            table.insert(highest_courses, gGlobalSyncTable.course3)
        end

        local random_index = math.random(#highest_courses)
        gGlobalSyncTable.level = highest_courses[random_index]

        round_start()
        if network_is_server() then
            gGlobalSyncTable.mapDeciding = false
            gGlobalSyncTable.votingTimer = (16 * 30) + 40
        end
    end
end

local function mario_update(m)
    if m.playerIndex ~= 0 then return end

    if gGlobalSyncTable.newTimer > 45 and gGlobalSyncTable.mapDeciding then
        isPaused = false
        showSettings = false
        m.freeze = 1
    end


    if gGlobalSyncTable.mapDeciding and gGlobalSyncTable.newTimer > 127 then
        if gGlobalSyncTable.newTimer == 128 then
            play_sound_with_freq_scale(SOUND_MENU_PAUSE_2, gGlobalSoundSource, 1)
            djui_popup_create("Voting has begun!", 1)

            position = 1
            pickedMap = false
        end

        if m.controller.stickX == 0 and m.controller.stickY == 0 then joystickCooldown = 0 end

        if not pickedMap then
            if m.controller.buttonPressed & L_JPAD ~= 0 or (m.controller.stickX < -0.5
            and joystickCooldown <= 0) and position > 0 then
                position = position - 1
                play_sound_with_freq_scale(SOUND_MENU_MESSAGE_NEXT_PAGE, gGlobalSoundSource, 1)
                joystickCooldown = 0.2 * 30
            end

            if m.controller.buttonPressed & R_JPAD ~= 0 or (m.controller.stickX > 0.5
            and joystickCooldown <= 0) and position < 2 then
                position = position + 1
                play_sound_with_freq_scale(SOUND_MENU_MESSAGE_NEXT_PAGE, gGlobalSoundSource, 1)
                joystickCooldown = 0.2 * 30
            end

            if joystickCooldown > 0 then joystickCooldown = joystickCooldown - 1 end

            if m.controller.buttonPressed & A_BUTTON ~= 0 then
                play_sound_with_freq_scale(SOUND_MENU_CLICK_FILE_SELECT, gGlobalSoundSource, 1)
                pickedMap = true

                if position == 0 then
                    gGlobalSyncTable.course1_v = gGlobalSyncTable.course1_v + 1
                elseif position == 1 then
                    gGlobalSyncTable.course2_v = gGlobalSyncTable.course2_v + 1
                elseif position == 2 then
                    gGlobalSyncTable.course3_v = gGlobalSyncTable.course3_v + 1
                end
            end
        else
            if (m.controller.buttonPressed & B_BUTTON) ~= 0 and gGlobalSyncTable.votingTimer >= 50 then
                play_sound_with_freq_scale(SOUND_MENU_CLICK_FILE_SELECT, gGlobalSoundSource, 1)
                pickedMap = false

                if position == 0 then
                    gGlobalSyncTable.course1_v = gGlobalSyncTable.course1_v - 1
                elseif position == 1 then
                    gGlobalSyncTable.course2_v = gGlobalSyncTable.course2_v - 1
                elseif position == 2 then
                    gGlobalSyncTable.course3_v = gGlobalSyncTable.course3_v - 1
                end
            end
        end
    end
end

local soundAllowed = {
    [SOUND_MENU_PAUSE_2] = 1,
    [SOUND_MENU_MESSAGE_NEXT_PAGE] = 1,
    [SOUND_MENU_CLICK_FILE_SELECT] = 1,
    [SOUND_MENU_CAMERA_BUZZ] = 1,
    [SOUND_GENERAL_RACE_GUN_SHOT] = 1
}

local function cancel_everything(sound)
    if gGlobalSyncTable.mapDeciding and gGlobalSyncTable.newTimer > 45
    and not soundAllowed[sound] then
        return NO_SOUND
    end
end

local function cancel_everything2()
    if gGlobalSyncTable.mapDeciding and gGlobalSyncTable.newTimer > 45 then
        return 0
    end
end

hook_event(HOOK_ON_PLAY_SOUND, cancel_everything)
hook_event(HOOK_CHARACTER_SOUND, cancel_everything2)
hook_event(HOOK_ON_HUD_RENDER, on_hud_render)
hook_event(HOOK_MARIO_UPDATE, mario_update)